//
//  Barcode.m
//  dffghhhjj
//
//  Created by liangchenying on 12-4-7.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "Barcode.h"
#import "ButtonPullDownPrepare.h"
#import "ButtonPullDownRealize.h"

@interface Barcode()
@property (nonatomic, retain) POSSDK	 *pos_sdk;
@end

@implementation Barcode
@synthesize Back;
@synthesize BarcodeData;
@synthesize BarcodeHeight;
@synthesize BarcodePrit;
@synthesize ModuleWidthButton;
@synthesize HriFontTypeButton;
@synthesize HriPositionButton;
@synthesize BarcodeTypeButton;
@synthesize Cut;
@synthesize Code128CharacterSetButton;
@synthesize BarcodeType;
@synthesize Code128CharacterSet;
@synthesize CodabarBeginningCode;
@synthesize CodaBarBeginningCodeButton;
@synthesize CodabarEndingCode;
@synthesize CodaBarEndingCodeButton;

@synthesize pos_sdk		                 = _pos_sdk;

@synthesize array_ModuleWidth	         = _array_ModuleWidth;
@synthesize array_HriFontType            = _array_HriFontType;
@synthesize array_HriPosition	         = _array_HriPosition;
@synthesize array_BarcodeType	         = _array_BarcodeType;
@synthesize array_Code128CharacterSet    = _array_Code128CharacterSet;
@synthesize array_CodabarBeginningCode   = _array_CodabarBeginningCode;
@synthesize array_CodabarEndingCode	     = _array_CodabarEndingCode;

@synthesize selectedModuleWidth	         = _selectedModuleWidth;
@synthesize selectedHriFontType          = _selectedHriFontType;
@synthesize selectedHriPosition	         = _selectedHriPosition;
@synthesize selectedBarcodeType	         = _selectedBarcodeType;
@synthesize selectedCode128CharacterSet  = _selectedCode128CharacterSet;
@synthesize selectedCodabarBeginningCode = _selectedCodabarBeginningCode;
@synthesize selectedCodabarEndingCode	 = _selectedCodabarEndingCode;

- (NSMutableArray*)array_ModuleWidth
{
    if(_array_ModuleWidth  == nil)
    {
        _array_ModuleWidth = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_ModuleWidth;
}

- (NSMutableArray*)array_HriFontType
{
    if(_array_HriFontType  == nil)
    {
        _array_HriFontType = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_HriFontType;
}

- (NSMutableArray*)array_HriPosition
{
    if(_array_HriPosition  == nil)
    {
        _array_HriPosition = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_HriPosition;
}

- (NSMutableArray*)array_BarcodeType
{
    if(_array_BarcodeType  == nil)
    {
        _array_BarcodeType = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_BarcodeType;
}

- (NSMutableArray*)array_Code128CharacterSet
{
    if(_array_Code128CharacterSet  == nil)
    {
        _array_Code128CharacterSet = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_Code128CharacterSet;
}

- (NSMutableArray*)array_CodabarBeginningCode
{
    if(_array_CodabarBeginningCode  == nil)
    {
        _array_CodabarBeginningCode = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_CodabarBeginningCode;
}

- (NSMutableArray*)array_CodabarEndingCode
{
    if(_array_CodabarEndingCode  == nil)
    {
        _array_CodabarEndingCode = [[NSMutableArray alloc] initWithCapacity:1024];
    }
    
    return _array_CodabarEndingCode;
}

SInt32 barCodeLengthMin[] = { 11, 11, 12, 7, 1, 1, 1, 1, 2 };
SInt32 barCodeLengthMax[] = { 12, 12, 13, 8, 255, 255, 255, 255, 255 };

- (id)initWithNibNamePOSSDK:(NSString *)nibNameOrNil pos_sdk:(POSSDK*)pos_sdk bundle:(NSBundle *)nibBundleOrNil
{
    self.pos_sdk = pos_sdk;
    return [self initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
}
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) 
    {
        //**************************************************************************************************
        //Add object for array_ModuleWidth
        [self.array_ModuleWidth addObject:@"2"];
        [self.array_ModuleWidth addObject:@"3"];
        [self.array_ModuleWidth addObject:@"4"];
        [self.array_ModuleWidth addObject:@"5"];
        [self.array_ModuleWidth addObject:@"6"];

        //**************************************************************************************************
        //Add object for array_HriFontType
        [self.array_HriFontType addObject:@"Standard ASCII"];
        [self.array_HriFontType addObject:@"Compressed ASCII"];

        //**************************************************************************************************
        //Add object for array_HriPosition
        [self.array_HriPosition addObject:@"No Hri"];
        [self.array_HriPosition addObject:@"Above Barcode"];
        [self.array_HriPosition addObject:@"Below Barcode"];
        [self.array_HriPosition addObject:@"Both Above and Below Barcode"];

        //**************************************************************************************************
        //Add object for array_BarcodeType
        [self.array_BarcodeType addObject:@"UPC-A"];
        [self.array_BarcodeType addObject:@"UPC-E"];
        [self.array_BarcodeType addObject:@"JAN13orEAN13"];
        [self.array_BarcodeType addObject:@"JAN8orEAN8"];
        [self.array_BarcodeType addObject:@"CODE39"];
        [self.array_BarcodeType addObject:@"ITF"];
        [self.array_BarcodeType addObject:@"CODABAR"];
        [self.array_BarcodeType addObject:@"CODE93"];
        [self.array_BarcodeType addObject:@"CODE128"];
 
        //**************************************************************************************************
        //Add object for array_Code128CharacterSet
        [self.array_Code128CharacterSet addObject:@"Character Set A"];
        [self.array_Code128CharacterSet addObject:@"Character Set B"];
        [self.array_Code128CharacterSet addObject:@"Character Set C"];

        //**************************************************************************************************
        //Add object for array_CodabarBeginningCode
        [self.array_CodabarBeginningCode addObject:@"A"];
        [self.array_CodabarBeginningCode addObject:@"B"];
        [self.array_CodabarBeginningCode addObject:@"C"];
        [self.array_CodabarBeginningCode addObject:@"D"];

        //**************************************************************************************************
        //Add object for array_CodabarEndingCode
        [self.array_CodabarEndingCode addObject:@"A"];
        [self.array_CodabarEndingCode addObject:@"B"];
        [self.array_CodabarEndingCode addObject:@"C"];
        [self.array_CodabarEndingCode addObject:@"D"];
        [self.array_CodabarEndingCode addObject:@"T"];
        [self.array_CodabarEndingCode addObject:@"E"];
        [self.array_CodabarEndingCode addObject:@"*"];
        [self.array_CodabarEndingCode addObject:@"N"];
    }
    return self;
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{ 
    [super viewDidLoad];
    
    self.selectedModuleWidth          = 0;
    self.selectedHriFontType          = 0;
    self.selectedHriPosition          = 0;
    self.selectedBarcodeType          = 0;
    self.selectedCode128CharacterSet  = 0;
    self.selectedCodabarBeginningCode = 0;
    self.selectedCodabarEndingCode    = 0;
    
    [self.BarcodeData                setDelegate:self];
    [self.BarcodeHeight              setDelegate:self];
   
    [self.ModuleWidthButton          setTitle:@"2" forState:UIControlStateNormal];
    [self.HriFontTypeButton          setTitle:@"Standard ASCII" forState:UIControlStateNormal];
    [self.HriPositionButton          setTitle:@"No Hri" forState:UIControlStateNormal];
    [self.BarcodeTypeButton          setTitle:@"UPC-A" forState:UIControlStateNormal];
    [self.Code128CharacterSetButton  setTitle:@"Character Set A" forState:UIControlStateNormal];
    [self.CodaBarBeginningCodeButton setTitle:@"A" forState:UIControlStateNormal];
    [self.CodaBarEndingCodeButton    setTitle:@"A" forState:UIControlStateNormal];
    
    [self.BarcodeHeight              setText:@"100"];
    [self.BarcodeData                setText:@"012345678912"];
    
    ButtonEnableAndAlpha(self.Code128CharacterSetButton, 0, 0); 
    ButtonEnableAndAlpha(self.Code128CharacterSet, 0, 0);
    ButtonEnableAndAlpha(self.CodaBarBeginningCodeButton, 0, 0); 
    ButtonEnableAndAlpha(self.CodabarBeginningCode, 0, 0);
    ButtonEnableAndAlpha(self.CodaBarEndingCodeButton, 0, 0); 
    ButtonEnableAndAlpha(self.CodabarEndingCode, 0, 0);

    self.BarcodeTypeButton.frame = CGRectMake(168,132,144,31);
    self.BarcodeType.frame       = CGRectMake(30,132,110,31);
}

- (void)viewDidUnload
{
    [self setBack:nil];
    [self setBarcodeData:nil];
    [self setBarcodeHeight:nil];
    [self setBarcodePrit:nil];
    [self setModuleWidthButton:nil];
    [self setHriFontTypeButton:nil];
    [self setHriPositionButton:nil];
    [self setBarcodeTypeButton:nil];
    [self setCut:nil];    
    [self setCode128CharacterSetButton:nil];
    [self setBarcodeType:nil];
    [self setCode128CharacterSet:nil];
    [self setCodabarBeginningCode:nil];
    [self setCodaBarBeginningCodeButton:nil];
    [self setCodabarEndingCode:nil];
    [self setCodaBarEndingCodeButton:nil];
    [super viewDidUnload];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}

//**************************************************************************************************
//Return to the main View by press the button "Back"
- (IBAction)Back:(id)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

//**************************************************************************************************
//Get Module Width Index
- (IBAction)selectModuleWidth:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedModuleWidth = selectedIndex;    
        [self.ModuleWidthButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Module Width" Sheet:self.array_ModuleWidth Selected:self.selectedModuleWidth DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Get Hri Font Type Index
- (IBAction)selectHriFontType:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedHriFontType = selectedIndex;  
        [self.HriFontTypeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Hri Font Type" Sheet:self.array_HriFontType Selected:self.selectedHriFontType DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Get Hri Position Index
- (IBAction)selectHriPosition:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedHriPosition = selectedIndex;   
        [self.HriPositionButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Hri Position" Sheet:self.array_HriPosition Selected:self.selectedHriPosition DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Get Barcode Type Index
- (IBAction)selectBarcodeType:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedBarcodeType = selectedIndex;
        
        //**************************************************************************************************
        //In the situation of of Codebar
        if (self.selectedBarcodeType == 6)
        {
            //**************************************************************************************************
            //Set Controllers enable to use or not
            ButtonEnableAndAlpha(self.Code128CharacterSetButton, 0, 0); 
            ButtonEnableAndAlpha(self.Code128CharacterSet, 0, 0);
            ButtonEnableAndAlpha(self.CodaBarBeginningCodeButton, 1, 1); 
            ButtonEnableAndAlpha(self.CodabarBeginningCode, 1, 1);
            ButtonEnableAndAlpha(self.CodaBarEndingCodeButton, 1, 1); 
            ButtonEnableAndAlpha(self.CodabarEndingCode, 1, 1);
            
            //**************************************************************************************************
            //Set controllers' position and size
            self.BarcodeTypeButton.frame          = CGRectMake(168,45,144,31);
            self.BarcodeType.frame                = CGRectMake(28,45,110,31);
            self.CodaBarBeginningCodeButton.frame = CGRectMake(168,90,144,31);
            self.CodabarBeginningCode.frame       = CGRectMake(28,90,110,31);
            self.CodaBarEndingCodeButton.frame    = CGRectMake(168,135,144,31);
            self.CodabarEndingCode.frame          = CGRectMake(28,135,110,31);
            
        }
        //**************************************************************************************************
        //In the situation of of Code128
        else if (self.selectedBarcodeType == 8) 
        {
            //**************************************************************************************************
            //Set controllers' position and size
            self.BarcodeTypeButton.frame = CGRectMake(168,92,144,31);
            self.BarcodeType.frame       = CGRectMake(28,92,110,31);
            
            //**************************************************************************************************
            //Set Controllers enable to use or not
            ButtonEnableAndAlpha(self.Code128CharacterSetButton, 1, 1); 
            ButtonEnableAndAlpha(self.Code128CharacterSet, 1, 1);
            ButtonEnableAndAlpha(self.CodaBarBeginningCodeButton, 0, 0); 
            ButtonEnableAndAlpha(self.CodabarBeginningCode, 0, 0);
            ButtonEnableAndAlpha(self.CodaBarEndingCodeButton, 0, 0); 
            ButtonEnableAndAlpha(self.CodabarEndingCode, 0, 0);
        }
        //**************************************************************************************************
        //In the situation of of other barcode
        else
        {
            //**************************************************************************************************
            //Set controllers' position and size
            self.BarcodeTypeButton.frame = CGRectMake(168,132,144,31);            
            self.BarcodeType.frame       = CGRectMake(30,132,110,31);

            //**************************************************************************************************
            //Set Controllers enable to use or not
            ButtonEnableAndAlpha(self.Code128CharacterSetButton, 0, 0); 
            ButtonEnableAndAlpha(self.Code128CharacterSet, 0, 0);
            ButtonEnableAndAlpha(self.CodaBarBeginningCodeButton, 0, 0); 
            ButtonEnableAndAlpha(self.CodabarBeginningCode, 0, 0);
            ButtonEnableAndAlpha(self.CodaBarEndingCodeButton, 0, 0); 
            ButtonEnableAndAlpha(self.CodabarEndingCode, 0, 0);

        }
        [self.BarcodeTypeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Barcode Type" Sheet:self.array_BarcodeType Selected:self.selectedBarcodeType DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Get Codabar Beginning Code Index
- (IBAction)selectCodabarBeginningCode:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedCodabarBeginningCode = selectedIndex;   
        [self.CodaBarBeginningCodeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Beginning Code" Sheet:self.array_CodabarBeginningCode Selected:self.selectedCodabarBeginningCode DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Get Codabar Ending Code Index
- (IBAction)selectCodabarEndingCode:(id)sender 
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedCodabarEndingCode = selectedIndex;   
        [self.CodaBarEndingCodeButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Ending code" Sheet:self.array_CodabarEndingCode Selected:self.selectedCodabarEndingCode DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Get Code128 Character Set
- (IBAction)selectCode128CharacterSet:(id)sender
{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        self.selectedCode128CharacterSet = selectedIndex;  
        [self.Code128CharacterSetButton setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    
    [ButtonPullDownRealize sheetPickerTitle:@"Code128 Character Set" Sheet:self.array_Code128CharacterSet Selected:self.selectedCode128CharacterSet DoneButton:done CancelButton:cancel Action:sender];
}

//**************************************************************************************************
//Exit the keyboard by clicking "return"
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    if ([string isEqualToString:@"\n"])
    {
        [self.BarcodeData   resignFirstResponder];
        [self.BarcodeHeight resignFirstResponder];
        
        return NO;
    } 
return YES;
}

//**************************************************************************************************
//barcode Print
- (IBAction)barcodePrint:(id)sender 
{
    SInt32   error_code             = SUCCESS;    
    SInt32   barcode_id             = 0;
    SInt32   height                 = 0;
    SInt32   module_width           = 0;
    SInt32   number                 = 0;
    SInt32   i                      = 0;
    SInt32   font_type              = 0;
    SInt32   Hri_position          = 0;
    NSData   *textNSData            = nil;
    NSString *code128_character_set = nil;
    NSString *data                  = nil;
	NSString *BarcodeName           = nil;

    
    //**************************************************************************************************
    //If Barcode Height == nil ,barcode cannot be printed.
    JudgeParamNil(BarcodeHeight, @"Data Height == nil,Please input Data Height");
    
    //**************************************************************************************************
    //If Barcode Height must be digit.
    JudgeParamDigitOrNot(BarcodeHeight, @"Data Height ERROR.It must be 1-255");

    //**************************************************************************************************
    //Get barcode height
    height = [self.BarcodeHeight.text intValue];
    JudgeParamRange(height, 1, 255, @"Barcode Height ERROR.It must be 1-255");
        
    //**************************************************************************************************
    //Get barcode id
	BarcodeName = [[NSString alloc] initWithFormat:@"Barcode%@", [self.BarcodeTypeButton currentTitle]];
    // get id by barcodeName
    barcode_id = [self barcodeGetIDByName:BarcodeName];
    [BarcodeName release];

    
    //**************************************************************************************************
    //Get barcode Module Width
    module_width = [[self.array_ModuleWidth objectAtIndex:self.selectedModuleWidth] intValue];
    
    //**************************************************************************************************
    //Add string by selectedCode128CharacterSet(index) 
    if ([[self.Code128CharacterSetButton currentTitle]  isEqual: @"Character Set B"]) 
    {
        code128_character_set = @"{B";
    }
    else if ([[self.Code128CharacterSetButton currentTitle] isEqual: @"Character Set C"]) 
    {
        code128_character_set = @"{C";
    }
    else
    {
        code128_character_set = @"{A";
    }
     
    textNSData = [self.BarcodeData.text dataUsingEncoding:NSUTF8StringEncoding];
    
    //**************************************************************************************************
    //If Data == nil ,barcode cannot be printed.
    JudgeParamNil(BarcodeData, @"Data == nil,Please input data");

    //**************************************************************************************************
    //Get data and limit data length
    if ([[self.BarcodeTypeButton currentTitle]isEqual: @"UPC-A"] || [[self.BarcodeTypeButton currentTitle] isEqual: @"UPC-E"] || [[self.BarcodeTypeButton currentTitle] isEqual: @"JAN13orEAN13"] || [[self.BarcodeTypeButton currentTitle] isEqual: @"JAN8orEAN8"])
    {
        if ([textNSData length] == barCodeLengthMin[self.selectedBarcodeType] || [textNSData length] == barCodeLengthMax[self.selectedBarcodeType]) 
        {
            data = BarcodeData.text;
        }
        else if ([textNSData length] < barCodeLengthMin[self.selectedBarcodeType])
        {
            number = barCodeLengthMin[self.selectedBarcodeType] - [textNSData length];
            data = self.BarcodeData.text;
            for (i=1; i<=number; i++) 
            {
              
                data = [data stringByAppendingString:@"0"];
            }
            
        }

        else if ([textNSData length] > barCodeLengthMax[self.selectedBarcodeType])
        {
            data = [self.BarcodeData.text substringToIndex:barCodeLengthMax[self.selectedBarcodeType]];
        }
        
    } 
    else if ([[self.BarcodeTypeButton currentTitle] isEqual: @"CODE128"])
    {
        data = [code128_character_set stringByAppendingString:BarcodeData.text];
    }
    else if ([[self.BarcodeTypeButton currentTitle] isEqual: @"CODABAR"])
    {
        data = [[[CodaBarBeginningCodeButton currentTitle] stringByAppendingString:BarcodeData.text] stringByAppendingString:[CodaBarEndingCodeButton currentTitle]];
    }
    else
    {
        data = self.BarcodeData.text;
    }
    
    if(self.selectedHriFontType == 0)          font_type = FontTypeStandardASCII;
    else if(self.selectedHriFontType == 1)     font_type = FontTypeCompressedASCII;
    
    if(self.selectedHriPosition == 0)          Hri_position = HRINone;
    else if(self.selectedHriPosition == 1)     Hri_position = HRIAbove;
    else if(self.selectedHriPosition == 2)     Hri_position = HRIBelow;
    else if(self.selectedHriPosition == 3)     Hri_position = HRIAboveAndBelow;
    
    //**************************************************************************************************
    //Get barcode data 
    textNSData = [data dataUsingEncoding:NSUTF8StringEncoding];
        
    //**************************************************************************************************
    //Print barcode  
    error_code = [self.pos_sdk barcodePrint1Dimension:textNSData BarcodeType:barcode_id ModuleWidth:module_width BarcodeHeight:height HriFontType:font_type HriPosition:Hri_position];
	
    //**************************************************************************************************
    // Alarm message
    if (([[self.BarcodeTypeButton currentTitle]isEqual: @"UPC-A"] || [[self.BarcodeTypeButton currentTitle] isEqual: @"UPC-E"] || [[self.BarcodeTypeButton currentTitle] isEqual: @"JAN13orEAN13"] || [[self.BarcodeTypeButton currentTitle] isEqual: @"JAN8orEAN8"] )&&error_code == ERR_INVALID_ARGUMENT)
    {
        AlertViewShow(@"Data ERROR!Characer Set is 0-9");
        goto ExitLine;
    }
    else if([[self.BarcodeTypeButton currentTitle] isEqual: @"CODE39"] &&error_code == ERR_INVALID_ARGUMENT)
    {
        AlertViewShow(@"Data ERROR!Characer Set is 0-9 A-Z - 。/ $ % + Space");
        goto ExitLine;        
    }
    else if([[self.BarcodeTypeButton currentTitle] isEqual: @"CODABAR"] &&error_code == ERR_INVALID_ARGUMENT)
    {
        AlertViewShow(@"Data ERROR!UITextField for Data must be input  0-9 - 。/ $ + ");
        goto ExitLine;        
    }

    if (error_code != SUCCESS)
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
        goto ExitLine;
    }
    
ExitLine:   
    return;
}
// get id by barcodeName
- (SInt32)barcodeGetIDByName:(NSString*)BarcodeName
{
	SInt32	index;

	for(index = 0; BarcodeNameIDSet[index].barcode_id != -1; index++)
	{
		if([BarcodeName compare:BarcodeNameIDSet[index].barcode_name] == 0)
		{
			return BarcodeNameIDSet[index].barcode_id;
		}
	}

	return -1;
}

//**************************************************************************************************
//Cut Paper
- (IBAction)Cut:(id)sender 
{
    SInt32 error_code = SUCCESS;
    
    error_code = [self.pos_sdk systemCutPaper:CutPartAfterFeed FeedDistance:20];
    if (error_code != SUCCESS) 
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
    }
    
ExitLine:

    return;
}

- (void)dealloc 
{
    [self.Back release];
    [self.BarcodeData release];
    [self.BarcodeHeight release];   
    [self.BarcodePrit release];
    [self.ModuleWidthButton release];
    [self.HriFontTypeButton release];
    [self.HriPositionButton release];
    [self.BarcodeTypeButton release];
    [self.array_ModuleWidth release];
    [self.array_HriFontType release];
    [self.array_HriPosition release];
    [self.array_BarcodeType release];
    [self.array_Code128CharacterSet release];
    [self.array_CodabarBeginningCode release];
    [self.array_CodabarEndingCode release];
    [self.Cut release];    
    [self.Code128CharacterSetButton release];
    [self.BarcodeType release];
    [self.Code128CharacterSet release];
    [self.CodabarBeginningCode release];
    [self.CodaBarBeginningCodeButton release];
    [self.CodabarEndingCode release];
    [self.CodaBarEndingCodeButton release];
    
    [super dealloc];
}
@end
